unit Stats;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls, 
     Gauges, 
     ExtCtrls, 
     dialogs,
     NWlib, 
     nwServer,
     nwTools, 
     Menus;

type
  TwinStats = class(TForm)
    Timer1: TTimer;
    statPanel: TPanel;
    sftLevel: TEdit;
    ttsLevel: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    serverVer: TEdit;
    Label9: TLabel;
    NumVolumes: TEdit;
    maxConns: TEdit;
    connsInUse: TEdit;
    peakConns: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Stats: TGroupBox;
    upTime: TEdit;
    Label1: TLabel;
    Panel2: TPanel;
    gUtilization: TGauge;
    Label2: TLabel;
    cache: TGroupBox;
    cacheHits: TEdit;
    writeBlockCount: TEdit;
    diskWriteCount: TEdit;
    numDirtyCacheHits: TEdit;
    cacheDirtyWaitTime: TEdit;
    cacheMaxConcurrent: TEdit;
    maxByteCount: TEdit;
    minCacheBuffers: TEdit;
    Label14: TLabel;
    Label20: TLabel;
    Label19: TLabel;
    Label18: TLabel;
    Label17: TLabel;
    Label16: TLabel;
    Label15: TLabel;
    Label21: TLabel;
    GroupBox1: TGroupBox;
    nlmList: TListBox;
    nlmInfoMemo: TMemo;
    nlmListPopup: TPopupMenu;
    unloadNLMMenuItem: TMenuItem;
    loadNLMMenuItem: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure nlmListClick(Sender: TObject);
    procedure unloadNLMMenuItemClick(Sender: TObject);
    procedure loadNLMMenuItemClick(Sender: TObject);
  private
    { Private declarations }
    function UpdateStats : boolean ;
  public
    { Public declarations }
  end;

var
  winStats: TwinStats;

implementation

{$R *.DFM}

procedure TwinStats.FormShow(Sender: TObject);
  begin
    {show nlmList}
    with nlmList.items do begin
      beginUpdate ;
      clear ;
      addStrings(getNLMList(0)) ;
      endUpdate ;
    end;
    updateStats;
  end;

function TwinStats.UpdateStats : boolean ;
  var
    serverStats  : TNWServerInfo ;
    memCacheInfo : TNWMemCacheInfo ;
  begin
    try
      { Get Server's Operational & I/O Statistics }
      if getServerStats(getPrimaryServerID, serverStats) then
        begin
          gUtilization.progress := serverStats.utilization ;
          serverVer.text   := serverStats.version                ;
          sftLevel.text    := intToStr(serverStats.sftlevel)     ;
          ttsLevel.text    := intToStr(serverStats.ttsLevel)     ;
          numVolumes.text  := intToStr(serverStats.numVolumes)   ;
          maxConns.text    := intToStr(serverStats.maxConns)     ;
          connsInUse.text  := intToStr(serverStats.connsInUse)   ;
          peakConns.text   := intToStr(serverStats.maxConnsUsed) ;
          upTime.text      := ticksToTimeString(serverStats.serverUpTime) ;
        end;  
      
      { Retrieve Server's File System Counters }
      if getCacheInfo(GetPrimaryServerID,memCacheInfo) then
        begin
          cacheHits.text          := intToStr(memCacheInfo.numCacheHits)     ;
          writeBlockCount.text    := intToStr(memCacheInfo.writeBlockCount)      ;
          diskWriteCount.text     := intToStr(memCacheInfo.diskWriteCount)    ;
          numDirtyCacheHits.text  := intToStr(memCacheInfo.numDirtyCacheHits) ;
          cacheDirtyWaitTime.text := intToStr(memCacheInfo.cacheDirtyWaitTime);
          cacheMaxConcurrent.text := intToStr(memCacheInfo.cacheMaxConcurrentWrites)    ;
          maxByteCount.text       := intToStr(memCacheInfo.maxByteCount)     ;
          minCacheBuffers.text    := intToStr(memCacheInfo.minCacheBuffers)        ;
        end;
      result := true ; 
    except
      result := false ;
    end;    
  end;

procedure TwinStats.Timer1Timer(Sender: TObject);
  begin
    timer1.enabled := updateStats ;
  end;

procedure TwinStats.nlmListClick(Sender: TObject);
  var
    nlmID   : longint ;
    nlmInfo : TNWNLMInfo ;
  begin
    with nlmList do 
      nlmID := longint(items.objects[itemIndex]) ;
                      {^^ see also:  getNLMID(0,'NLMNAME.NLM') ^^}  
    if getNLMInfo(0,nlmID,nlmInfo) then
      with nlmInfo,nlmInfoMemo.lines do begin
        beginUpdate ;
        clear ;
        add(nlmName) ;
        add('NLM Filename: ' + NLMFileName) ;
        add('NLM Version: ' + version) ;
        add('NLM Date: ' + dateToStr(nlmDate)) ;
        add('NLM ID: ' + intToStr(nlmID)) ;
        add('NLM Type : ' + intToStr(nlmType)) ;
        add('Parent ID: ' + intToStr(parentID)) ;
        add('Allocated Free Bytes: ' + allTrim(format('%7.0n',[allocFreeBytes * 1.0]))) ;
        add('Copyright: ' + copyRight) ;
        endUpdate ;
      end
    else
      alertBox('Error Retrieving NLM Information;;Check Console Privileges') ;  
  end;

procedure TwinStats.unloadNLMMenuItemClick(Sender: TObject);
  begin
    with nlmList do begin
      if (items.count < 1) then
        exit ;
      if (itemIndex < 0) then
        itemIndex := 0 ;
      if noYesBox('Warning - Unloading ' + items[itemIndex] + 
                  ';;Unloading NLMs Can Disable Server Features;;Are You Sure?') then
        begin
          if nlmUnload(0,items[itemIndex]) then
            begin
              okBox(items[itemIndex] + ' Unloaded Successfully') ;
              formShow(sender) ;
            end
          else
            alertBox(items[itemIndex] + ' Could Not Be Unloaded;;Check Console Rights') ;  
        end;    
    end;    
  end;

procedure TwinStats.loadNLMMenuItemClick(Sender: TObject);
  var
    fileName : string ;
  begin
    if (not inputQuery('Load NLM File','Type NLM Path and/or FileName:',fileName)) then
      exit ;
    if nlmLoad(0,fileName,''{any nlm load params go here}) then
      begin
        okBox(fileName + ';;Loaded Successfully') ;
        formShow(sender) ;
      end  
    else
      okBox(fileName + ';;Could Not Be Loaded;;Check Console Rights/NLM File') ;    
  end;

end.
